//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import "mainView.h"
#import <UIKit/UIKit.h>
#import "NTAG5_NFC_LIB.h"
#import "Config.h"

@interface mainView ()


@end

@implementation mainView

- (void)viewDidLoad {
    [super viewDidLoad];
    [self initViewUIElements];
}

- (IBAction)setI2cSlaveModeOptionSelected:(id)sender {
    CATransition *animation = [CATransition animation];
    
    animation.type = kCATransitionReveal;
    animation.duration = 0.1;
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden = YES;
    
    [[NTAG5_NFC_LIB sharedInstance] initSession:^(NSData *aData) {
    } onFailure:^(NSError *error) {
    }];
    
    NSLog(@"Waiting for connection...");
    while ([[NTAG5_NFC_LIB sharedInstance] isConnect] == 0){}

    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] setI2CSlave:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {} onFailure:^(NSError *error) {}];
    }
}

- (IBAction)setI2cMasterModeOptionSelected:(id)sender {
    CATransition *animation = [CATransition animation];
    
    animation.type = kCATransitionReveal;
    animation.duration = 0.1;
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden = YES;
    
    [[NTAG5_NFC_LIB sharedInstance] initSession:^(NSData *aData) {
    } onFailure:^(NSError *error) {
    }];
    
    NSLog(@"Waiting for connection...");
    while ([[NTAG5_NFC_LIB sharedInstance] isConnect] == 0){}
       
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] setI2CMaster:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {} onFailure:^(NSError *error) {}];
    }
}

- (IBAction)setGPIOPWMModeOptionSelected:(id)sender {
    CATransition *animation = [CATransition animation];
    
    animation.type = kCATransitionReveal;
    animation.duration = 0.1;
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden = YES;
    
    [[NTAG5_NFC_LIB sharedInstance] initSession:^(NSData *aData) {
    } onFailure:^(NSError *error) {
    }];
    
    NSLog(@"Waiting for connection...");
    while ([[NTAG5_NFC_LIB sharedInstance] isConnect] == 0){}
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] setGPIOPWM:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {} onFailure:^(NSError *error) {}];
    }
}

- (IBAction)getUseCaseCongifOptionSelected:(id)sender {
    CATransition *animation = [CATransition animation];
    
    animation.type = kCATransitionReveal;
    animation.duration = 0.1;
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden = YES;
    
    [[NTAG5_NFC_LIB sharedInstance] initSession:^(NSData *aData) {
    } onFailure:^(NSError *error) {
    }];
  
    NSLog(@"Waiting for connection...");
    while ([[NTAG5_NFC_LIB sharedInstance] isConnect] == 0){}
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] getUseCaseConfig:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {} onFailure:^(NSError *error) {}];
    }
}

- (IBAction)setSlaveModeButtonClick:(id)sender {
    [[NTAG5_NFC_LIB sharedInstance] initSession:^(NSData *aData) {
    } onFailure:^(NSError *error) {
    }];
    
    NSLog(@"Waiting for connection...");
    while ([[NTAG5_NFC_LIB sharedInstance] isConnect] == 0){}
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] setI2CSlave:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {} onFailure:^(NSError *error) {}];
    }
}

- (IBAction)setMasterModeButtonClick:(id)sender {
    [[NTAG5_NFC_LIB sharedInstance] initSession:^(NSData *aData) {
    } onFailure:^(NSError *error) {
    }];
    
    NSLog(@"Waiting for connection...");
    while ([[NTAG5_NFC_LIB sharedInstance] isConnect] == 0){}
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] setI2CMaster:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {} onFailure:^(NSError *error) {}];
    }
}

- (IBAction)setGpioPwmModeButtonClick:(id)sender {
    [[NTAG5_NFC_LIB sharedInstance] initSession:^(NSData *aData) {
       } onFailure:^(NSError *error) {
       }];
       
       NSLog(@"Waiting for connection...");
       while ([[NTAG5_NFC_LIB sharedInstance] isConnect] == 0){}
       
       if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
           NSLog(@"Connected!!!");
           
           [[Config sharedInstance] setGPIOPWM:^(NSData *aData) {
           } onFailure:^(NSError *error) {
           }];
           
       }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
           NSLog(@"Not connected!!!");
           [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {} onFailure:^(NSError *error) {}];
       }
}

- (IBAction)getConfigButtonClick:(id)sender {
    [[NTAG5_NFC_LIB sharedInstance] initSession:^(NSData *aData) {
    } onFailure:^(NSError *error) {
    }];
    
    NSLog(@"Waiting for connection...");
    while ([[NTAG5_NFC_LIB sharedInstance] isConnect] == 0){}
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] getUseCaseConfig:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {} onFailure:^(NSError *error) {}];
    }
}


/*---------------------- UI METHODS ----------------------*/

- (void)initViewUIElements {
    _i2cMasterChannelButton.layer.cornerRadius = 8;
    _gpioUseCaseButton.layer.cornerRadius = 8;
    _pwmUseCaseButton.layer.cornerRadius = 8;
    _passthroughButton.layer.cornerRadius = 8;
    _almUseCaseButton.layer.cornerRadius = 8;
    _setSlaveModeButton.layer.cornerRadius = 8;
    _setMasterModeButton.layer.cornerRadius = 8;
    _setGpioPwmButton.layer.cornerRadius = 8;
    _getConfigButton.layer.cornerRadius = 8;
    
    _setSlaveModeButton.titleLabel.textAlignment = UITextAlignmentCenter;
    _setMasterModeButton.titleLabel.textAlignment = UITextAlignmentCenter;
    _setGpioPwmButton.titleLabel.textAlignment = UITextAlignmentCenter;
    _getConfigButton.titleLabel.textAlignment = UITextAlignmentCenter;
    
    _configDropDownList.userInteractionEnabled = true;
    _configDropDownList.backgroundColor = UIColor.whiteColor;
    _configDropDownList.layer.borderColor = [UIColor lightGrayColor].CGColor;
    _configDropDownList.layer.borderWidth = 0.75;
    _configDropDownList.hidden = true;
    
    [self setAutoHideDropDownMenuListener];
}

-(void)HideWhenTappedAnywhere{
    CATransition *animation = [CATransition animation];
    
    animation.type = kCATransitionReveal;
    animation.duration = 0.1;
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden = YES;
}

- (void)setAutoHideDropDownMenuListener {
    
    UITapGestureRecognizer *singleTap   = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(HideWhenTappedAnywhere)];
    
    singleTap.numberOfTapsRequired = 1;
    
    [self.mainView setUserInteractionEnabled:YES];
    [self.mainView addGestureRecognizer:singleTap];
}

- (IBAction)configButtonClick:(id)sender {
    CATransition *animation = [CATransition animation];
    
    animation.type = kCATransitionReveal;
    animation.duration = 0.1;
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    
    if (_configDropDownList.hidden == false)
        _configDropDownList.hidden = true;
    else
        _configDropDownList.hidden = false;
}

@end
